Ext.data.JsonP.sol_common_ix_functions_ForEach({"tagname":"class","name":"sol.common.ix.functions.ForEach","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.functions.ForEach.js","href":"sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach"}],"author":[{"tagname":"author","name":"ESt, ELO Digital Office GmbH","email":null}],"version":["1.0"],"eloix":true,"requires":["sol.common.IxUtils","sol.common.JsonUtils","sol.common.ObjectUtils","sol.common.RepoUtils","sol.common.SordUtils","sol.common.Template","sol.common.WfUtils","sol.common.ix.FunctionBase","sol.common.ix.RfUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.FunctionBase","mixins":["sol.common.mixins.Inject","sol.common.mixins.ObjectFilter","sol.common.mixins.ObjectSort"],"uses":[],"members":[{"name":"callback","tagname":"cfg","owner":"sol.common.ix.functions.ForEach","id":"cfg-callback","meta":{}},{"name":"columns","tagname":"cfg","owner":"sol.common.ix.functions.ForEach","id":"cfg-columns","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.FunctionBase","id":"cfg-objId","meta":{}},{"name":"options","tagname":"cfg","owner":"sol.common.ix.functions.ForEach","id":"cfg-options","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common.ix.functions.ForEach","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"inject","tagname":"property","owner":"sol.common.ix.functions.ForEach","id":"property-inject","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"mixin","tagname":"property","owner":"sol.common.mixins.ObjectSort","id":"property-mixin","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"buildTable","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"method-buildTable","meta":{}},{"name":"convertToElements","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"method-convertToElements","meta":{"private":true}},{"name":"executeCallback","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"method-executeCallback","meta":{}},{"name":"executeDeleteInstructions","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"method-executeDeleteInstructions","meta":{"private":true}},{"name":"executeElementService","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"method-executeElementService","meta":{"private":true}},{"name":"forEachElement","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"method-forEachElement","meta":{"private":true}},{"name":"generateDeleteInstructions","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"method-generateDeleteInstructions","meta":{"private":true}},{"name":"generateSort","tagname":"method","owner":"sol.common.mixins.ObjectSort","id":"method-generateSort","meta":{"private":true}},{"name":"hasSortCriteria","tagname":"method","owner":"sol.common.mixins.ObjectSort","id":"method-hasSortCriteria","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"isObj","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"method-isObj","meta":{"private":true}},{"name":"moveVal","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"method-moveVal","meta":{"private":true}},{"name":"mv","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"method-mv","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"method-process","meta":{"abstract":true}},{"name":"sanitizeConfig","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"method-sanitizeConfig","meta":{"private":true}},{"name":"sordsToElements","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"method-sordsToElements","meta":{"private":true}},{"name":"sortArray","tagname":"method","owner":"sol.common.mixins.ObjectSort","id":"method-sortArray","meta":{}},{"name":"validStr","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"method-validStr","meta":{"private":true}},{"name":"RF_sol_common_function_ForEach","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"static-method-RF_sol_common_function_ForEach","meta":{"static":true}},{"name":"onEnterNode","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"static-method-onEnterNode","meta":{"static":true}},{"name":"onExitNode","tagname":"method","owner":"sol.common.ix.functions.ForEach","id":"static-method-onExitNode","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.functions.ForEach","short_doc":"Iterates over a sord's MapTable(s) or elements provided via parameter or a service call and calls a registered functi...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.FunctionBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a><div class='subclass '><strong>sol.common.ix.functions.ForEach</strong></div></div></div><h4>Mixins</h4><div class='dependency'>sol.common.mixins.Inject</div><div class='dependency'>sol.common.mixins.ObjectFilter</div><div class='dependency'><a href='#!/api/sol.common.mixins.ObjectSort' rel='sol.common.mixins.ObjectSort' class='docClass'>sol.common.mixins.ObjectSort</a></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.IxUtils' rel='sol.common.IxUtils' class='docClass'>sol.common.IxUtils</a></div><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a></div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach' target='_blank'>sol.common.ix.functions.ForEach.js</a></div></pre><div class='doc-contents'><p>Iterates over a sord's MapTable(s) or elements provided via parameter or a service call and calls a registered function for each element.</p>\n\n<p>Each row/element is passed to the function as parameter. The parameter name must be defined\nas options.elementArg and could be called \"sordMetadata\".</p>\n\n<p>Scroll down for an example using a service as data source instead of a MAPTABLE.</p>\n\n<h3>Example: Short Intro</h3>\n\n<p>Define the table structure in <code>columns</code>. Omit the \"1\" from the end of the field name which you\ndefined in the form-editor.</p>\n\n<p>If this function is running in a workflow, it will have access to objId and flowId automatically.\nOtherwise, define both as a parameter.</p>\n\n<pre><code>{\n  \"objId\": \"5203\", // optional, when in workflow\n  \"flowId\": 59,    // optional, when in workflow\n  \"columns\": {\n    \"wfMap\": [\n      \"COURSE_ENROLLMENT_USER\",\n      \"COURSE_ENROLLMENT_STATUS\"\n    ],\n    \"map\": []\n  },\n  \"options\": {\n    \"elementArg\": \"sordMetadata\"\n  },\n  \"callback\": {\n    \"name\": \"RF_sol_learning_function_CreateEnrollmentHeadless\",\n    \"args\": {\n      \"myadditionalargument\": \"{{translate 'my.locale.string'}}\"\n    }\n  }\n}\n</code></pre>\n\n<p>The function would now be called with a parameter called <code>sordMetadata</code> for every table row.\nThe parameter would look like this</p>\n\n<pre><code>{\n  \"sordMetadata\": {\n      \"COURSE_ENROLLMENT_USER\": \"Felix Unger\",\n      \"COURSE_ENROLLMENT_STATUS\": \"ENROLLED\"\n  },\n  \"myadditionalargument\": \"This is a localized text\"\n}\n</code></pre>\n\n<p>To view these parameters, define <code>options.dryRun:true</code>. The callback will not be executed then.\nInstead you can see all values with with the function will be called. (One array entry is one call).</p>\n\n<p>The object displayed in \"result\" will be passed to the function defined in callback.name.</p>\n\n<h3>Example: TemplateSord</h3>\n\n<p>Your target function might require a TemplateSord instead of a flat object. Simply define</p>\n\n<pre><code>  \"options\": {\n    \"elementArg\": \"sordMetadata\",\n    \"elementAsTemplateSord\": true\n  },\n</code></pre>\n\n<p>The result would look like this:</p>\n\n<pre><code>{\n  \"sordMetadata\": {\n    \"wfMapKeys\": {\n      \"COURSE_ENROLLMENT_USER\": \"Felix Unger\",\n      \"COURSE_ENROLLMENT_STATUS\": \"ENROLLED\"\n    }\n  },\n  \"myadditionalargument\": \"This is a localized text\"\n}\n</code></pre>\n\n<h3>Example: Mapping field values</h3>\n\n<p>Most of the time, the target function will probably require different field names from the original\nsord's field names.</p>\n\n<p>You can use a mapping to move fields from one property to another: Please note, that the property key\nis relative to sordMetadata (or whatever is defined as <code>options.elementArg</code>), while the property value\nis not. This enables moving values from e.g. a templateSord to an outer scope</p>\n\n<pre><code>  \"options\": {\n    \"elementArg\": \"sordMetadata\",\n    \"elementAsTemplateSord\": true,\n    \"moveValues\": {\n      \"wfMapKeys.COURSE_ENROLLMENT_STATUS\": \"sordMetadata.objKeys.COURSE_ENROLLMENT_STATUS\",\n      \"wfMapKeys.COURSE_ENROLLMENT_USER\": \"thisis.something.else\",\n    }\n  }\n</code></pre>\n\n<p>Of course the mapping source would not include \"wfMapKeys\", if the \"elementAsTemplateSord\" option\nwas set to false. The mapping target path can be as deeply nested as you wish.</p>\n\n<pre><code>{\n  \"sordMetadata\": {\n    \"wfMapKeys\": {},\n    \"objKeys\": {\n      \"COURSE_ENROLLMENT_STATUS\": \"ENROLLED\"\n    }\n  },\n  \"thisis\": {\n    \"something\": {\n      \"else\": \"ENROLLED\"\n    }\n  },\n  \"myadditionalargument\": \"This is a localized text\"\n}\n</code></pre>\n\n<p>Example: Adding additional parameters</p>\n\n<p>Most functions need additional parameters. And you will also want to have access to fields of the\n(workflow) sord, which contains the maptable.</p>\n\n<p>E.g. imagine an invoice sord containing a maptable of items. Each item will have an item number\nand item description. However, you want to call a createInvoiceItem function which also requires\na field called \"INVOICE_NO\" which is not contained in the maptable but on the base sord.\nYou can now add this field using a handlebars helper in the additional <code>callback.args</code> object.\nIn handlebars you have access to the (invoice) sord.</p>\n\n<p>If additional \"callback.args\" are defined, they are deep-merged into the prepared parameter\nwhich contains the sordMetadata element:</p>\n\n<pre><code>element: { sordMetadata: { mapKeys: { ... } } }\nargs:    { test: true, sordMetadata: { testInner: true } }\nresult:  { test: true, sordMetadata: { testInner: true, mapKeys: { ... } } }\n</code></pre>\n\n<p>A complete example could look like this:</p>\n\n<pre><code>{\n  \"objId\": \"5203\", // optional, when in workflow\n  \"flowId\": 59,    // optional, when in workflow\n  \"columns\": {\n    \"wfMap\": [\n      \"COURSE_ENROLLMENT_USER\",\n      \"COURSE_ENROLLMENT_STATUS\"\n    ],\n    \"map\": []\n  },\n  \"options\": {\n    \"elementArg\": \"sordMetadata\",\n    \"elementAsTemplateSord\": true,\n    \"moveValues\": {\n      \"wfMapKeys.COURSE_ENROLLMENT_STATUS\": \"objKeys.COURSE_ENROLLMENT_STATUS\"\n    }\n  },\n  \"callback\": {\n    \"name\": \"RF_sol_learning_function_CreateEnrollmentHeadless\",\n    \"args\": {\n      \"myadditionalargument\": \"{{translate 'my.locale.string'}}\",\n      \"sordMetadata\": {\n        \"objId\": \"{{sord.id}}\",\n        \"flowId\": \"{{flowId}}\",\n        \"objKeys\": {\n          \"COURSE_REFERENCE\": \"{{{sord.objKeys.COURSE_REFERENCE}}}\",\n          \"COURSE_NAME\": \"{{{sord.objKeys.COURSE_NAME}}}\"\n        }\n      }\n    }\n  }\n}\n</code></pre>\n\n<p>Which results in</p>\n\n<pre><code>    {\n      \"sordMetadata\": {\n        \"mapKeys\": {},\n        \"wfMapKeys\": {\n          \"COURSE_ENROLLMENT_USER\": \"Administrator\"\n        },\n        \"objKeys\": {\n          \"COURSE_ENROLLMENT_STATUS\": \"ENROLLED\",\n          \"COURSE_REFERENCE\": \"0007\",\n          \"COURSE_NAME\": \"Test\"\n        },\n        \"objId\": \"5203\",\n        \"flowId\": \"59\"\n      },\n      \"myadditionalargument\": \"my.locale.string\"\n    }\n</code></pre>\n\n<h3>Filtering</h3>\n\n<p>If you want that only specific rows would be passed to the callback, you can define filter rules in\nthe options. For each row, all of the given filter will be applied and only matching objects will\nbe kept and passed to the callback function. It doesn't matter if you're using map table or wfMap table.\nThe crucial point ist, that your filter prop path is matching a object path of the result object.\nThe output format is depending on elementAsTemplateSord option or your moveValues operations.</p>\n\n<p>The filter will be applied after the moveValue operation.</p>\n\n<h4>Applying a filter with single filter value</h4>\n\n<pre><code>{\n  \"options\": {\n    \"filter\": [\n      { \"prop\" : \"sordMetadata.mapKeys.SOLUTION_FIELD\", value: \"A -*\"}\n    ]\n  }\n}\n</code></pre>\n\n<h4>Applying a filter with multiple filter values</h4>\n\n<pre><code>{\n  \"options\": {\n    \"filter\": [\n      { \"prop\" : \"sordMetadata.mapKeys.SOLUTION_FIELD\", value: [\"A -*\", \"B -*\"]}\n    ]\n  }\n}\n</code></pre>\n\n<h4>Returns</h4>\n\n<p>An array of all return values of the function calls or all prepared parameters which\nwould have been sent during each function call if <code>options.dryRun</code> is set to true.</p>\n\n<pre><code>{ data: [{ objId: \"12345\", flowId: \"33\" }] }\n</code></pre>\n\n<h3>Sorting</h3>\n\n<p>It is possible to specify certain search criteria after which the result is sorted.</p>\n\n<p>Important: Only the result on the service side is sorted, not on the database level.\nThis can lead to incorrect sorting when using pagination.</p>\n\n<p>Several sorting criteria can also be specified. The first element is always\nthe most important criterion. In the case of identical values, the following sorting criteria\nare applied.</p>\n\n<p>Via <code>type</code> a sorting algorithm from {@see <a href=\"#!/api/sol.common.ObjectSortUtils\" rel=\"sol.common.ObjectSortUtils\" class=\"docClass\">sol.common.ObjectSortUtils</a>} can be passed as a string.\nThe name must be identical to the functions offered there. Otherwise,\nthe default is always selected as the standard.</p>\n\n<p>Possible types at the moment: <code>default</code>, <code>date</code>.</p>\n\n<p>The type <code>date</code> enables sorting with the help of date objects.</p>\n\n<pre><code>{\n \"options\": {\n    \"elementArg\" : \"data\"\n    \"sort\": [\n       { \"prop\": \"data.startDate\", \"type\": \"date\" },\n       { \"prop\": \"data.reference\"}\n    ]\n  }\n}\n</code></pre>\n\n<h3>Complete Example: Use service results (e.g. sords) as data source</h3>\n\n<p>If your data is not contained in a MAPTABLE, you can also use an external service to provide e.g. sords.</p>\n\n<p>In this example, we want to find all courses in the archive using the RF_sol_common_service_SordProvider as <code>elementService</code>.\nThen, we want to prepend \"POPULAR\" to each course's name, when the course has a 5 star rating, using the RF_sol_function_Set function.</p>\n\n<p>To enable access to the element's data when the callback is prepared for execution, we define <code>renderArgsWithElement\": true</code>.\nThis enables the use of the element's data in the <code>callback.args</code> object's strings.</p>\n\n<pre><code>{\n  \"elementService\": {\n    \"name\": \"RF_sol_common_service_SordProvider\",\n    \"args\": {\n      \"masks\": [\"Course\"],\n      \"search\": [\n         { \"key\": \"SOL_TYPE\", \"value\": [\"COURSE\"] }\n         { \"key\": \"REFERENCE\", \"value\": \"{{sord.objKeys.REFERENCE}}\" }\n      ],\n      \"output\": [\n        { \"source\": { \"type\": \"SORD\", \"key\": \"id\" }, \"target\": { \"prop\": \"id\" } },\n        { \"source\": { \"type\": \"GRP\", \"key\": \"COURSE_NAME\" }, \"target\": { \"prop\": \"name\" } },\n        { \"source\": { \"type\": \"MAP\", \"key\": \"COURSE_STAR_SCORE\" }, \"target\": { \"prop\": \"stars\" } }\n      ]\n    },\n    options: {\n      forTemplating: true\n    }\n  },\n  \"options\": {\n    \"elementArg\": \"data\",\n    \"moveValues\": { \"id\": \"objId\" }, // the SET-function we use in the callback needs an objId.\n    \"renderArgsWithElement\": true,\n    \"filter\": [ { \"prop\": \"data.stars\", \"value\": \"5\" } ], // since SordProvider supports filtering too, we could have filtered above instead of here\n    \"dryRun\": true // set this to false to actually execute the SET function in the end\n  },\n  \"callback\": {\n    \"name\": \"RF_sol_function_Set\",\n    \"args\": {\n      \"entries\": [ { \"type\": \"GRP\", \"key\": \"COURSE_NAME\", \"value\": \"POPULAR: {{{element.data.name}}}\" }]\n    }\n  }\n}\n</code></pre>\n\n<p>Info: instead of moving the <code>id</code> to <code>objId</code> using the <code>moveValues</code> option, we also could have defined <code>objId: \"{{element.data.id}}\"</code>\nin the <code>callback.args</code> object.</p>\n\n<p>If you want to convert each item to an mapTable entry you can use the variable $mapIndex from your elementArg variable (e.g. data)\nWith Handlebars you can append each trailing number to your configuration result</p>\n\n<pre><code>{ \"type\": \"MAP\", \"key\": \"COURSE_NAME{{element.data.$mapIndex}}\", \"value\": \"{{{element.data.course}}}\" }\n</code></pre>\n\n<p>In this case you should avoid to use filter from the foreach function because we can't ensure that the index is correct.\nFor example the filter function will delete the second row, so your result is that $mapIndex = 2 is missing.</p>\n\n<pre><code>{\n  \"args\": [\n    {\n      \"entries\": [ { \"type\": \"GRP\", \"key\": \"COURSE_NAME1\", \"value\": \"POPULAR: BS ELO Contract\" } ]\n    },\n    {\n      \"entries\": [ { \"type\": \"GRP\", \"key\": \"COURSE_NAME3\", \"value\": \"POPULAR: BS ELO Learning\" } ]\n    }\n  ]\n}\n</code></pre>\n\n<p>Instead use sordprovider filter function</p>\n\n<pre><code> {\n  \"elementService\": {\n    \"name\": \"RF_sol_common_service_SordProvider\",\n    \"args\": {\n      \"masks\": [\"Course\"],\n      \"search\": [{ \"key\": \"SOL_TYPE\", \"value\": [\"COURSE\"] }],\n      \"filter\": [ { \"prop\": \"stars\", \"value\": \"5\" } ]\n      \"output\": [\n        { \"source\": { \"type\": \"SORD\", \"key\": \"id\" }, \"target\": { \"prop\": \"id\" } },\n        { \"source\": { \"type\": \"GRP\", \"key\": \"COURSE_NAME\" }, \"target\": { \"prop\": \"name\" } },\n        { \"source\": { \"type\": \"MAP\", \"key\": \"COURSE_STAR_SCORE\" }, \"target\": { \"prop\": \"stars\" } }\n      ]\n    }\n    ...\n  }\n</code></pre>\n\n<p>Attention: Only services which return an array of objects as the <code>sords</code> or <code>elements</code> property can be used with the ForEach function.</p>\n\n<h4>Result</h4>\n\n<pre><code>{\n  \"args\": [\n    {\n      \"data\": { \"name\": \"BS ELO Contract\", \"stars\": \"5\" } }\n      \"objId\": \"5204\",\n      \"entries\": [ { \"type\": \"GRP\", \"key\": \"COURSE_NAME\", \"value\": \"POPULAR: BS ELO Contract\" } ]\n    },\n    {\n      \"data\": { \"name\": \"BS ELO Learning\", \"stars\": \"5\" } }\n      \"objId\": \"5442\",\n      \"entries\": [ { \"type\": \"GRP\", \"key\": \"COURSE_NAME\", \"value\": \"POPULAR: BS ELO Learning\" } ]\n    }\n  ],\n  \"excluded\": 7  // number of elements which did not match the filter criteria\n}\n</code></pre>\n\n<p>If <code>dryRun</code> is set to false, the SET-function will be called with each of the two objects in the <code>args</code> array.</p>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-callback' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-cfg-callback' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-cfg-callback' class='name expandable'>callback</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>name of registered function (e.g. \"RF_sol_function_Set\")</p>\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>additional arguments for the callback</p>\n</div></li></ul></div></div></div><div id='cfg-columns' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-cfg-columns' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-cfg-columns' class='name expandable'>columns</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>min. ...</div><div class='long'><p>min. one of wfMap or map column names must be defined</p>\n<ul><li><span class='pre'>wfMap</span> : String[]<div class='sub-desc'><p>(optional) column names of fields which are a WFMAPTABLE column (see docs)</p>\n</div></li><li><span class='pre'>map</span> : String[]<div class='sub-desc'><p>(optional) column names of fields which are a MAPTABLE column (see docs)</p>\n</div></li></ul></div></div></div><div id='cfg-objId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-options' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-cfg-options' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-cfg-options' class='name expandable'>options</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<ul><li><span class='pre'>elementArg</span> : Boolean<div class='sub-desc'><p>property name, at which the maptable row object will be stored in the parameter object</p>\n</div></li><li><span class='pre'>elementAsTemplateSord</span> : Boolean (optional)<div class='sub-desc'><p>(optional) formats the maptable row object as a templatesord before adding it to the parameter object</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>dryRun</span> : Boolean (optional)<div class='sub-desc'><p>(optional) callback will not be executed, only prepared parameters will be returned. (good for debugging)</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>deleteAfterUse</span> : Boolean (optional)<div class='sub-desc'><p>(optional) if set it to true, all applied rows to the callback function will be deleted. If dryRun = true, deleteInstructions will only be returned.</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>filter</span> : Object[]<div class='sub-desc'><p>filter rules which will be applied to each row</p>\n</div></li></ul></div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;callback&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-inject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-property-inject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-property-inject' class='name expandable'>inject</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{sord: {sordIdFromProp: &quot;objId&quot;, flowIdFromProp: &quot;flowId&quot;, optional: true}, originalConfig: {jsonFromProp: &quot;configStr&quot;, forTemplating: false, template: false}, config: {jsonFromProp: &quot;configStr&quot;, forTemplating: false, template: true}, flowId: {prop: &quot;flowId&quot;, forTemplating: true}}</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div><div id='property-mixin' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.mixins.ObjectSort' rel='sol.common.mixins.ObjectSort' class='defined-in docClass'>sol.common.mixins.ObjectSort</a><br/><a href='source/lib_sol.common.ObjectSortUtils.html#sol-common-mixins-ObjectSort-property-mixin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.mixins.ObjectSort-property-mixin' class='name expandable'>mixin</a> : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>true</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-buildTable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-method-buildTable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-method-buildTable' class='name expandable'>buildTable</a>( <span class='pre'>columns, sord</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Helpers ...</div><div class='long'><p>Helpers</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>columns</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>sord</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-convertToElements' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-method-convertToElements' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-method-convertToElements' class='name expandable'>convertToElements</a>( <span class='pre'>table, opt</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>table</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>opt</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-executeCallback' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-method-executeCallback' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-method-executeCallback' class='name expandable'>executeCallback</a>( <span class='pre'>callback, args</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>External dependencies ...</div><div class='long'><p>External dependencies</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>callback</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-executeDeleteInstructions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-method-executeDeleteInstructions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-method-executeDeleteInstructions' class='name expandable'>executeDeleteInstructions</a>( <span class='pre'>deleteInstructions</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>deleteInstructions</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-executeElementService' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-method-executeElementService' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-method-executeElementService' class='name expandable'>executeElementService</a>( <span class='pre'>cfg</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-forEachElement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-method-forEachElement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-method-forEachElement' class='name expandable'>forEachElement</a>( <span class='pre'>elements, opts, cbOpts</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>elements</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>opts</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>cbOpts</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-generateDeleteInstructions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-method-generateDeleteInstructions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-method-generateDeleteInstructions' class='name expandable'>generateDeleteInstructions</a>( <span class='pre'>elements, table</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>elements</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>table</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-generateSort' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.mixins.ObjectSort' rel='sol.common.mixins.ObjectSort' class='defined-in docClass'>sol.common.mixins.ObjectSort</a><br/><a href='source/lib_sol.common.ObjectSortUtils.html#sol-common-mixins-ObjectSort-method-generateSort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.mixins.ObjectSort-method-generateSort' class='name expandable'>generateSort</a>( <span class='pre'>sorts</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sorts</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-hasSortCriteria' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.mixins.ObjectSort' rel='sol.common.mixins.ObjectSort' class='defined-in docClass'>sol.common.mixins.ObjectSort</a><br/><a href='source/lib_sol.common.ObjectSortUtils.html#sol-common-mixins-ObjectSort-method-hasSortCriteria' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.mixins.ObjectSort-method-hasSortCriteria' class='name expandable'>hasSortCriteria</a>( <span class='pre'>sortCriterias</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sortCriterias</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-isObj' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-method-isObj' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-method-isObj' class='name expandable'>isObj</a>( <span class='pre'>o</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-moveVal' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-method-moveVal' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-method-moveVal' class='name expandable'>moveVal</a>( <span class='pre'>srcObj, tgtObj, source, target</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>srcObj</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>tgtObj</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>source</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>target</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-mv' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-method-mv' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-method-mv' class='name expandable'>mv</a>( <span class='pre'>opts, element</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>opts</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>element</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"><span class='abstract' >abstract</span></span></div><div class='description'><div class='short'>Implementation of function modules' process. ...</div><div class='long'><p>Implementation of function modules' process.\nThis function must be implemented by the child class and should contain the logic of the function module.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-process\" rel=\"sol.common.ix.FunctionBase-method-process\" class=\"docClass\">sol.common.ix.FunctionBase.process</a></p></div></div></div><div id='method-sanitizeConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-method-sanitizeConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-method-sanitizeConfig' class='name expandable'>sanitizeConfig</a>( <span class='pre'>cfg, sordsProvided</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>sordsProvided</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-sordsToElements' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-method-sordsToElements' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-method-sordsToElements' class='name expandable'>sordsToElements</a>( <span class='pre'>sords, opt</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sords</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>opt</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-sortArray' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.mixins.ObjectSort' rel='sol.common.mixins.ObjectSort' class='defined-in docClass'>sol.common.mixins.ObjectSort</a><br/><a href='source/lib_sol.common.ObjectSortUtils.html#sol-common-mixins-ObjectSort-method-sortArray' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.mixins.ObjectSort-method-sortArray' class='name expandable'>sortArray</a>( <span class='pre'>arr, sortCriterias, options</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Sort an array by specify sortCriteria. ...</div><div class='long'><p>Sort an array by specify sortCriteria.</p>\n\n<p>Imagine you have the following array:</p>\n\n<pre><code>[ { data: { propA: \"A\", propB: \"B\"} }, {data: { propA: \"A\", propB: \"B\"} }]\n</code></pre>\n\n<p>If you want to sort by propA you can use the following sortCriteria structure.\n { prop: \"data.propA\" }</p>\n\n<p>Now the array will be sort by the object prop <code>propA</code> with ObjectSortUtils.default sort function.</p>\n\n<p>The sortCriteria will be used ObjectUtils.getProp function to determine the object property,\nso the object could be sort by deeper structures as well as flat structures</p>\n\n<p>If you want simple sort an array by a prop you can easily pass the object keypath\ninstead of a sortCritiera object</p>\n\n<p>   sortCriterias: [\"data.propA\"]</p>\n\n<p>A sortCriteria has furthermore options. To use another sorting strategy you can pass\nanother function from ObjectSortUtils. Currently supported functions are default, date, number</p>\n\n<p> sortCriterias: [{ prop: \"data.propDate\", type: \"date\" }]</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : Array&lt;Object&gt;<div class='sub-desc'><p>The array to sort</p>\n</div></li><li><span class='pre'>sortCriterias</span> : Array&lt;Object&gt;<div class='sub-desc'><p>determine the props to sort</p>\n</div></li><li><span class='pre'>options</span> : *<div class='sub-desc'><p>object</p>\n<ul><li><span class='pre'>clone</span> : Boolean (optional)<div class='sub-desc'><p>If you want to sort the original object set this option to false. Default is true</p>\n<p>Defaults to: <code>true</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>sorted array</p>\n</div></li></ul></div></div></div><div id='method-validStr' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-method-validStr' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-method-validStr' class='name expandable'>validStr</a>( <span class='pre'>s</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>s</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_common_function_ForEach' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-static-method-RF_sol_common_function_ForEach' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-static-method-RF_sol_common_function_ForEach' class='name expandable'>RF_sol_common_function_ForEach</a>( <span class='pre'>Execution, args</span> ) : Object<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n...</div><div class='long'><p>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_FunctionName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-onEnterNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-static-method-onEnterNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-static-method-onEnterNode' class='name expandable'>onEnterNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called before a workflow node is activated. ...</div><div class='long'><p>This function is called before a workflow node is activated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The activated node ID</p>\n</div></li></ul></div></div></div><div id='static-method-onExitNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ForEach'>sol.common.ix.functions.ForEach</span><br/><a href='source/sol.common.ix.functions.ForEach.html#sol-common-ix-functions-ForEach-static-method-onExitNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ForEach-static-method-onExitNode' class='name expandable'>onExitNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called after a workflow node is deactivated. ...</div><div class='long'><p>This function is called after a workflow node is deactivated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The deactivated node ID</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});